/****************************************************************************************/
/**
  Copyright (c) 2008 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	Pwm.h
  \brief    	This file contains all initialization and function statements to handle the \n
                emulated Pwm module.
  \author   	Freescale Semiconductor
  \author       r01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version      0.1
  \date     	4/16/2008 9:55:45 AM
  \warning      
  
  * History:
  
*/
/****************************************************************************************/
#ifndef _PWM_H_
  #define _PWM_H_
  
  #include "Pwm_Cfg.h"
  #include "Port.h"
  #include "Derivative.h"
  #include "Pit.h"  
  
#if (PWM_ERROR_DETECT == ON)   /* If Pwm Error Layer Enabled, validate errors */ 
  #include "Pwm_ReportError.h"
#endif  

/** Pit Interrupt period    */
#define SET_33US_TIMEBASE    ((uint32_t)0x00000840)
#define SIU_GPDO_BASE_ADDR   0xFFFE8600


 /*--------------------- Functions --------------------------*/
   void vfnPwm_Init(const Pwm_ChannelConfigType *PwmCfgPtr);  
   void vfnCoreInterruptHandling(uint8_t u8InterruptType);
   void vfnSetDuty_Cycle(uint8_t u8PwmChannel, uint32_t u32DutyCyle);
   void vfnSetPeriodAndDuty(uint8_t u8PwmChannel, uint32_t u32Period ,uint32_t u32DutyCyle);
   void Pwm_Generation_Fnc(void);
   asm void Pwm_Generation_Asm_Fnc(void);
  
#endif